<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('doctor_ncf_authorizations', function (Blueprint $table) {
            if (Schema::hasColumn('doctor_ncf_authorizations', 'insurer_id')) {
                $table->dropForeign(['insurer_id']);
                $table->dropColumn('insurer_id');
            }

            // Ajusta unique si existía con insurer_id
            // Deja solo doctor_id + ncf_type_id
            $table->unique(['doctor_id', 'ncf_type_id']);
        });
    }

    public function down(): void
    {
        Schema::table('doctor_ncf_authorizations', function (Blueprint $table) {
            $table->foreignId('insurer_id')->nullable()->constrained('insurers');
            $table->dropUnique(['doctor_id', 'ncf_type_id']);
        });
    }
};
